<?php
class Cron extends CI_Controller
{
    public $module_name;
    function __construct()
    {

        parent::__construct();
        $this->module_name = $this->router->fetch_module();
        $this->load->model('../extensions/'.$this->module_name.'/models/Night_audit_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Company_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Room_model');
        $this->load->model('../extensions/'.$this->module_name.'/models/Cron_model');
        $this->load->helper('timezone_helper');
        $this->load->library('night_audit');
    }


    function hourly()
    {   
        $company_batch = $this->input->post('company_batch');
        
        $log = "";
        // don't sent out emails when in testing server 
        if ($_SERVER['HTTP_HOST'] != "localhost" && 
            $_SERVER['HTTP_HOST'] != "minical.core")
        {
            $log = $log."\n\nSending emails: ".$this->send_emails($company_batch);
        }
        else
        {
            echo ("testing environment, we're not sending out emails");
        }
                
        
        $log = $log."\n\nRun Night Audits: ".$this->run_night_audits($company_batch);
        $log = $log."\n\nRun Housekeeping Auto Clean: ".$this->run_housekeeping_auto_clean($company_batch);
        $log = $log."\n\nRun Housekeeping Auto Dirty: ".$this->run_housekeeping_auto_dirty($company_batch);
        $log = $log."\n\nSubscriptions updated ";
        echo $log;
        $system_time = date("Y-m-d H:i:s");
        // $this->load->model('Cron_model');
        $this->Cron_model->insert_log($system_time, $log);

        //$this->load->library('Chargify_wrapper');
        //$this->chargify_wrapper->bulk_update_subscription();
        
        
    }

   function send_emails($company_batch)
    {
    

            $auto_night_audit_enabled_companies = $this->Night_audit_model->get_auto_night_audit_enabled_companies($company_batch);

            $log = "";
            // Right now, every companies has auto_night_audit enabled by default
            foreach ($auto_night_audit_enabled_companies as $company)
            {              
                $company_id = $company['company_id'];

                $company_time_zone = $this->Company_model->get_time_zone($company_id);
                $today = convert_to_local_time(new DateTime(), $company_time_zone)->format("Y-m-d");
                $companys_local_time = convert_to_local_time(new DateTime(), $company_time_zone)->format("H:i:s");      
                $scheduled_time = $company['night_audit_auto_run_time'];        
                
                
                if (
                        (strtotime($company['selling_date']) < strtotime($today)) &&
                        strtotime($companys_local_time) > strtotime($scheduled_time)
                )
                {
                    // sending invoice email daily
                    if ($company['send_invoice_email_automatically'] == '1')
                    {
                        $email_count = $this->_send_invoice_email($company_id);
                        $log = $log."\n".$company['company_id']." ".$company['company_name']." sent ".$email_count." emails ";
                    }
                    if ($company['automatic_feedback_email'] == '1')
                    {
                        $email_count = $this->_send_feedback_email($company_id);
                        $log = $log."\n".$company['company_id']." ".$company['company_name']." sent ".$email_count." review emails ";
                    }
                }

            }
                
            return $log;
    }
     function run_night_audits($company_batch)
    {
       
        $auto_night_audit_enabled_companies = $this->Night_audit_model->get_auto_night_audit_enabled_companies($company_batch);

        $log = "";
        // Right now, every companies has auto_night_audit enabled by default
        foreach ($auto_night_audit_enabled_companies as $company)
        {
            $company_id = $company['company_id'];
            $company_time_zone = $company['time_zone'];
            
            if (!(isset($company_time_zone) && $company_time_zone))
            {
                $company_time_zone = "America/New_York";        
            }
            
            // if night_audit_auto_run_time is set afternoon, have it run day after. Otherwise, run it on same day.
            // for example, if today is 2015-01-01 and night_audit_auto_run_time is set as 20:00:00, 
            // run it on 2015-01-01 20:00:00
            // however, if night_audit_auto_run_time is set as 03:00:00, then run it on 2015-01-02 03:00:00
            if (strtotime($company['night_audit_auto_run_time']) < strtotime("12:00:00"))
            {
                $scheduled_date = date('Y-m-d', strtotime($company['selling_date'] . ' +1 day'));
            }
            else
            {
                $scheduled_date = $company['selling_date'];
            }
            
            $current_date_time = convert_to_local_time(new DateTime(), $company_time_zone)->format("Y-m-d H:i:s");      
            $scheduled_date_time = $scheduled_date." ".$company['night_audit_auto_run_time'];

            echo "<br/>".$company_id." ".$company['company_name']." - ".$current_date_time." > ".$scheduled_date_time;
            
            // you shouldn't just run night audit because company's local time is before scheduled_date_time.
            // Otherwise, if current time is 2015-01-01 10:00:00 and scheduled time is 2015-01-01 23:00:00,
            // night audit will run (which isn't what we want)
            if (strtotime($current_date_time) > strtotime($scheduled_date_time))
            {
                echo (" - ran night audit");
                $night_audit_response = $this->night_audit->run_night_audit($company['company_id']);
                $log = $log."\n".$company_id." ".$company['company_name']." - Ran night audit ($night_audit_response) at ".$current_date_time." ".$current_date_time." > ".$scheduled_date_time;
                
            }
        
        }
        //echo $log;
        return $log;
    }
    
function run_housekeeping_auto_clean($company_batch)
    {
        $auto_housekeeping_enabled_companies = $this->Company_model->get_auto_housekeeping_enabled_companies(false, $company_batch);
        $log_str = "\n";
        

        foreach($auto_housekeeping_enabled_companies as $company)
        {
            $company_id = $company['company_id'];
            $company_time_zone = $this->Company_model->get_time_zone($company_id);
            $companys_local_time = convert_to_local_time(new DateTime(), $company_time_zone)->format("H:i:s");      
            $housekeeping_auto_clean_time = $company['housekeeping_auto_clean_time'];

            
            // if the time difference between company's local time and housekeeping auto clean time is less than 60 minutes,
            // clean all the rooms.
            // by using the time difference, we can prevent auto housekeeping running over and over again
            $minute_difference = abs(strtotime($companys_local_time) - strtotime($housekeeping_auto_clean_time)) / 60;
            //echo "$company_id companys_local_time ".$companys_local_time." housekeeping_auto_clean_time ".$housekeeping_auto_clean_time." $minute_difference<br/>";
            //$log_str = $log_str."\n".$company_id." ".$company['company_name']." local: ".$companys_local_time." auto_run_time: ".$housekeeping_auto_clean_time." minute diff: ".$minute_difference;
            $log = "";
            // if minute difference is less than 15, mathmatically, this runs only once a day if cron makes this function run every 30 minutes
            if ($minute_difference < 30)
            {
                $this->Room_model->set_rooms_clean($company_id);
                $log = $log."\n".$company_id." ".$company['company_name']." - All rooms cleaned ( local: ".$companys_local_time." auto_run_time: ".$housekeeping_auto_clean_time." minute diff: ".$minute_difference.")";
            }
        }   
        return $log;
    }


function run_housekeeping_auto_dirty($company_batch)
    {
        $today = Date("Y-m-d");
      
       
        $auto_housekeeping_enabled_companies = $this->Company_model->get_auto_housekeeping_enabled_companies($is_room_dirty = true, $company_batch);
        $log_str = "\n";
        $log = "";
        foreach($auto_housekeeping_enabled_companies as $company)
        {
            $company_id = $company['company_id'];
            $company_time_zone = $this->Company_model->get_time_zone($company_id);
            $companys_local_time = convert_to_local_time(new DateTime(), $company_time_zone)->format("H:i:s");      
            $housekeeping_auto_dirty_time = $company['housekeeping_auto_dirty_time'];
            $selling_date = $this->Company_model->get_selling_date($company_id); // get selling date

            // if the time difference between company's local time and housekeeping auto dirty time is less than 60 minutes,
            // Dirty all the rooms.
            // by using the time difference, we can prevent auto housekeeping running over and over again
            $minute_difference = abs(strtotime($companys_local_time) - strtotime($housekeeping_auto_dirty_time)) / 60;
            
            
            // if minute difference is less than 15, mathmatically, this runs only once a day if cron makes this function run every 30 minutes
            if ($minute_difference < 30)
            {
                if($company_id != 2637) {
                    $this->Room_model->set_rooms_dirty($company_id, $selling_date);
                    $log = $log."\n".$company_id." ".$company['company_name']." - All checked-in rooms dirty ( local: ".$companys_local_time." auto_run_time: ".$housekeeping_auto_dirty_time." minute diff: ".$minute_difference.")";
                }
            }
        }   
        return $log;
    }


     function get_auto_night_audit_enabled_companies()
    {
        
        $auto_night_audit_enabled_companies = $this->Night_audit_model->get_auto_night_audit_enabled_companies();
        $get_auto_housekeeping_enabled_companies_clean = $this->Company_model->get_auto_housekeeping_enabled_companies(false);
        $get_auto_housekeeping_enabled_companies_dirty = $this->Company_model->get_auto_housekeeping_enabled_companies(true);
        
        $companies = array();
        foreach($auto_night_audit_enabled_companies as $auto_night_audit_enabled_company) {
            $companies[] = $auto_night_audit_enabled_company['company_id'];
        }
        foreach($get_auto_housekeeping_enabled_companies_clean as $get_auto_housekeeping_enabled_company) {
            $companies[] = $get_auto_housekeeping_enabled_company['company_id'];
        }
        foreach($get_auto_housekeeping_enabled_companies_dirty as $get_auto_housekeeping_enabled_company) {
            $companies[] = $get_auto_housekeeping_enabled_company['company_id'];
        }
        $companies = array_unique($companies);
        
        echo json_encode($companies);
        return;
    }

    function _send_invoice_email($company_id)
    {
        $this->load->library('email');
        $this->load->library('email_template');
        $this->load->model('Booking_model');
                
        $selling_date = $this->Company_model->get_selling_date($company_id);
        $yesterday = Date("Y-m-d", strtotime("-1 days", strtotime($selling_date)));
        
        $this->load->model("Booking_model");
        $bookings_checked_out_yesterday = $this->Booking_model->get_bookings_by_check_out_date($company_id, $yesterday);

        $email_count = 0;

        foreach ($bookings_checked_out_yesterday as $booking)
        {
                    $email_count++;
                    $this->email_template->send_invoice_email($booking->booking_id);
                    $this->Booking_model->update_booking_email_status($booking->booking_id);
                }
                    
        return $email_count;
        
    }
    
    function _send_feedback_email($company_id)
    {
        $this->load->library('email');
        $this->load->library('email_template');
        $this->load->model('Booking_model');
                
        $selling_date = $this->Company_model->get_selling_date($company_id);
        $yesterday = Date("Y-m-d", strtotime("-1 days", strtotime($selling_date)));
        
        $this->load->model("Booking_model");
        $bookings_checked_out_yesterday = $this->Booking_model->get_bookings_by_check_out_date($company_id, $yesterday);

        $email_count = 0;

        foreach ($bookings_checked_out_yesterday as $booking)
        {
            $email_count++;
            //echo "$booking->booking_id <br/>";
            $this->email_template->send_rating_email($booking->booking_id);
        }
                    
        return $email_count;
    }

}
